from django.urls import path
from django.views.generic import RedirectView
from . import views

app_name = 'suppliers'

urlpatterns = [
    # Supplier URLs
    path('', views.SupplierListView.as_view(), name='supplier_list'),
    path('add/', views.SupplierCreateView.as_view(), name='supplier_create'),
    path('<int:pk>/', views.SupplierDetailView.as_view(), name='supplier_detail'),
    path('<int:pk>/edit/', views.SupplierUpdateView.as_view(), name='supplier_update'),
    path('<int:pk>/delete/', views.SupplierDeleteView.as_view(), name='supplier_delete'),
    path('<int:pk>/toggle-status/', views.toggle_supplier_status, name='toggle_supplier_status'),
    
    # Supplier Contact URLs
    path('<int:supplier_pk>/contacts/add/', views.SupplierContactCreateView.as_view(), name='supplier_contact_create'),
    path('contacts/<int:pk>/edit/', views.SupplierContactUpdateView.as_view(), name='supplier_contact_update'),
    path('contacts/<int:pk>/delete/', views.SupplierContactDeleteView.as_view(), name='supplier_contact_delete'),
    
    # Supplier Document URLs
    path('<int:supplier_pk>/documents/add/', views.SupplierDocumentCreateView.as_view(), name='supplier_document_create'),
    path('documents/<int:pk>/edit/', views.SupplierDocumentUpdateView.as_view(), name='supplier_document_update'),
    path('documents/<int:pk>/delete/', views.SupplierDocumentDeleteView.as_view(), name='supplier_document_delete'),
    path('documents/<int:pk>/download/', views.supplier_document_download, name='supplier_document_download'),
    
    # Supplier Note URLs
    path('<int:supplier_pk>/notes/add/', views.SupplierNoteCreateView.as_view(), name='supplier_note_create'),
    path('notes/<int:pk>/edit/', views.SupplierNoteUpdateView.as_view(), name='supplier_note_update'),
    path('notes/<int:pk>/delete/', views.SupplierNoteDeleteView.as_view(), name='supplier_note_delete'),
    
    # Supplier Category URLs
    path('categories/', views.SupplierCategoryListView.as_view(), name='supplier_category_list'),
    path('categories/add/', views.SupplierCategoryCreateView.as_view(), name='supplier_category_create'),
    path('categories/<int:pk>/edit/', views.SupplierCategoryUpdateView.as_view(), name='supplier_category_update'),
    path('categories/<int:pk>/delete/', views.SupplierCategoryDeleteView.as_view(), name='supplier_category_delete'),
    
    # API Endpoints
    path('api/suppliers/autocomplete/', views.supplier_autocomplete, name='api_supplier_autocomplete'),
    path('api/suppliers/<int:pk>/', views.supplier_detail_api, name='api_supplier_detail'),
    
    # Redirects
    path('supplier/', RedirectView.as_view(pattern_name='suppliers:supplier_list', permanent=False)),
]
