from django.contrib import admin
from .models import Sale, SaleItem, Payment

class SaleItemInline(admin.TabularInline):
    model = SaleItem
    extra = 0
    readonly_fields = ('product', 'quantity', 'price', 'total')

class PaymentInline(admin.TabularInline):
    model = Payment
    extra = 0
    readonly_fields = ('amount', 'payment_method', 'payment_date')

@admin.register(Sale)
class SaleAdmin(admin.ModelAdmin):
    list_display = ('invoice_number', 'customer', 'cashier', 'branch', 'total_amount', 'payment_status', 'created_at')
    list_filter = ('payment_status', 'branch', 'cashier', 'created_at')
    search_fields = ('invoice_number', 'customer__first_name', 'customer__last_name')
    readonly_fields = ('created_at', 'updated_at')
    inlines = [SaleItemInline, PaymentInline]

@admin.register(Payment)
class PaymentAdmin(admin.ModelAdmin):
    list_display = ('sale', 'amount', 'payment_method', 'payment_date')
    list_filter = ('payment_method', 'payment_date')
    search_fields = ('sale__invoice_number',)
