from django.test import TestCase
from django.urls import reverse
from django.contrib.auth import get_user_model
from branches.models import Branch

User = get_user_model()

class ReportsViewTest(TestCase):
    def setUp(self):
        self.branch = Branch.objects.create(
            name='Test Branch',
            address='123 Test St'
        )
        
        self.admin_user = User.objects.create_user(
            email='admin@example.com',
            password='testpassword',
            first_name='Admin',
            last_name='User',
            role='admin',
            branch=self.branch
        )
        
        self.manager_user = User.objects.create_user(
            email='manager@example.com',
            password='testpassword',
            first_name='Manager',
            last_name='User',
            role='manager',
            branch=self.branch
        )
        
        self.cashier_user = User.objects.create_user(
            email='cashier@example.com',
            password='testpassword',
            first_name='Cashier',
            last_name='User',
            role='cashier',
            branch=self.branch
        )
    
    def test_reports_access(self):
        # Admin should have access
        self.client.login(username='admin@example.com', password='testpassword')
        response = self.client.get(reverse('reports'))
        self.assertEqual(response.status_code, 200)
        self.client.logout()
        
        # Manager should have access
        self.client.login(username='manager@example.com', password='testpassword')
        response = self.client.get(reverse('reports'))
        self.assertEqual(response.status_code, 200)
        self.client.logout()
        
        # Cashier should not have access
        self.client.login(username='cashier@example.com', password='testpassword')
        response = self.client.get(reverse('reports'))
        self.assertEqual(response.status_code, 302)  # Redirect to login or access denied
