from django.urls import path
from . import views

urlpatterns = [
    path('', views.license_list, name='license_list'),
    path('add/', views.license_add, name='license_add'),
    path('<int:license_id>/revoke/', views.license_revoke, name='license_revoke'),
    path('<int:license_id>/renew/', views.license_renew, name='license_renew'),
    path('activate/', views.license_activate, name='license_activate'),
    path('create-business/', views.admin_create_business, name='admin_create_business'),
    path('business-created/', views.business_creation_success, name='business_creation_success'),
]
