from PIL import Image, ImageDraw
import os

# Create icons directory if it doesn't exist
os.makedirs('static/pwa/icons', exist_ok=True)

# Icon sizes needed for PWA
sizes = [72, 96, 128, 144, 152, 192, 384, 512]

# Create a simple icon for each size
for size in sizes:
    # Create a new image with a blue background
    img = Image.new('RGB', (size, size), color=(13, 110, 253))  # Bootstrap primary blue
    d = ImageDraw.Draw(img)
    
    # Add a simple 'POS' text in the center
    d.text((size//2, size//2), 'POS', fill='white', 
           anchor='mm',  # Center the text
           font_size=size//3)  # Scale font size based on image size
    
    # Save the image
    img.save(f'static/pwa/icons/icon-{size}x{size}.png')
    
print(f"Generated {len(sizes)} icon sizes in static/pwa/icons/")

# Create a simple 192x192 icon for the home screen
img = Image.new('RGB', (192, 192), color=(13, 110, 253))
d = ImageDraw.Draw(img)
d.text((96, 96), 'POS', fill='white', anchor='mm', font_size=64)
img.save('static/pwa/icons/icon-192x192.png')

# Create a simple 512x512 icon for the splash screen
img = Image.new('RGB', (512, 512), color=(13, 110, 253))
d = ImageDraw.Draw(img)
d.text((256, 256), 'POS', fill='white', anchor='mm', font_size=170)
img.save('static/pwa/icons/icon-512x512.png')
