# Generated by Django 5.2.5 on 2025-10-30 19:13

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from decimal import Decimal
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('branches', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ExpenseCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='category name')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('is_active', models.BooleanField(default=True, verbose_name='active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
            ],
            options={
                'verbose_name': 'expense category',
                'verbose_name_plural': 'expense categories',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Expense',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reference', models.CharField(max_length=50, unique=True, verbose_name='reference number')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=12, validators=[django.core.validators.MinValueValidator(Decimal('0.01'))], verbose_name='amount')),
                ('tax_amount', models.DecimalField(decimal_places=2, default=0.0, max_digits=12, validators=[django.core.validators.MinValueValidator(Decimal('0.00'))], verbose_name='tax amount')),
                ('total_amount', models.DecimalField(decimal_places=2, max_digits=12, validators=[django.core.validators.MinValueValidator(Decimal('0.01'))], verbose_name='total amount')),
                ('expense_date', models.DateField(default=django.utils.timezone.now, verbose_name='expense date')),
                ('payment_date', models.DateField(blank=True, null=True, verbose_name='payment date')),
                ('payment_method', models.CharField(choices=[('cash', 'Cash'), ('bank_transfer', 'Bank Transfer'), ('cheque', 'Cheque'), ('credit_card', 'Credit Card'), ('mobile_money', 'Mobile Money'), ('other', 'Other')], default='cash', max_length=20, verbose_name='payment method')),
                ('payment_reference', models.CharField(blank=True, max_length=100, verbose_name='payment reference')),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('pending', 'Pending Approval'), ('approved', 'Approved'), ('rejected', 'Rejected'), ('paid', 'Paid')], default='draft', max_length=20, verbose_name='status')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('receipt', models.FileField(blank=True, null=True, upload_to='expense_receipts/%Y/%m/%d/', verbose_name='receipt')),
                ('approved_at', models.DateTimeField(blank=True, null=True, verbose_name='approved at')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('approved_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='approved_expenses', to=settings.AUTH_USER_MODEL, verbose_name='approved by')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='expenses', to='branches.branch', verbose_name='branch')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='created_expenses', to=settings.AUTH_USER_MODEL, verbose_name='created by')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='expenses', to='expenses.expensecategory', verbose_name='category')),
            ],
            options={
                'verbose_name': 'expense',
                'verbose_name_plural': 'expenses',
                'ordering': ['-expense_date', '-created_at'],
                'permissions': [('approve_expense', 'Can approve expense'), ('view_all_expenses', 'Can view all expenses'), ('export_expenses', 'Can export expense data')],
            },
        ),
        migrations.CreateModel(
            name='ExpenseItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(max_length=255, verbose_name='description')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=12, validators=[django.core.validators.MinValueValidator(Decimal('0.01'))], verbose_name='amount')),
                ('quantity', models.DecimalField(decimal_places=2, default=1, max_digits=10, validators=[django.core.validators.MinValueValidator(Decimal('0.01'))], verbose_name='quantity')),
                ('unit_price', models.DecimalField(decimal_places=2, max_digits=12, validators=[django.core.validators.MinValueValidator(Decimal('0.01'))], verbose_name='unit price')),
                ('tax_rate', models.DecimalField(decimal_places=2, default=0.0, max_digits=5, validators=[django.core.validators.MinValueValidator(Decimal('0.00')), django.core.validators.MinValueValidator(Decimal('100.00'))], verbose_name='tax rate (%)')),
                ('tax_amount', models.DecimalField(decimal_places=2, default=0.0, max_digits=12, verbose_name='tax amount')),
                ('total_amount', models.DecimalField(decimal_places=2, max_digits=12, verbose_name='total amount')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('expense', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='expenses.expense', verbose_name='expense')),
            ],
            options={
                'verbose_name': 'expense item',
                'verbose_name_plural': 'expense items',
                'ordering': ['id'],
            },
        ),
    ]
