from django.contrib import admin
from .models import CompanySettings, Notification

@admin.register(CompanySettings)
class CompanySettingsAdmin(admin.ModelAdmin):
    list_display = ('company_name', 'contact_email', 'contact_phone')
    search_fields = ('company_name', 'contact_email')

@admin.register(Notification)
class NotificationAdmin(admin.ModelAdmin):
    list_display = ('title', 'message', 'branch', 'created_at', 'is_read')
    list_filter = ('is_read', 'branch', 'created_at')
    search_fields = ('title', 'message')
