from django.test import TestCase
from django.urls import reverse
from .models import User

class UserModelTest(TestCase):
    def setUp(self):
        self.admin_user = User.objects.create_user(
            email='admin@example.com',
            password='testpassword',
            first_name='Admin',
            last_name='User',
            role='admin'
        )
        
        self.manager_user = User.objects.create_user(
            email='manager@example.com',
            password='testpassword',
            first_name='Manager',
            last_name='User',
            role='manager'
        )
        
        self.cashier_user = User.objects.create_user(
            email='cashier@example.com',
            password='testpassword',
            first_name='Cashier',
            last_name='User',
            role='cashier'
        )
    
    def test_user_creation(self):
        self.assertEqual(User.objects.count(), 3)
    
    def test_role_properties(self):
        self.assertTrue(self.admin_user.is_admin)
        self.assertFalse(self.admin_user.is_manager)
        self.assertFalse(self.admin_user.is_cashier)
        
        self.assertFalse(self.manager_user.is_admin)
        self.assertTrue(self.manager_user.is_manager)
        self.assertFalse(self.manager_user.is_cashier)
        
        self.assertFalse(self.cashier_user.is_admin)
        self.assertFalse(self.cashier_user.is_manager)
        self.assertTrue(self.cashier_user.is_cashier)

class LoginTest(TestCase):
    def setUp(self):
        self.user = User.objects.create_user(
            email='testuser@example.com',
            password='testpassword',
            first_name='Test',
            last_name='User',
            role='admin'
        )
    
    def test_login_view(self):
        response = self.client.get(reverse('login'))
        self.assertEqual(response.status_code, 200)
        self.assertTemplateUsed(response, 'accounts/login.html')
    
    def test_login_success(self):
        response = self.client.post(reverse('login'), {
            'username': 'testuser@example.com',
            'password': 'testpassword'
        })
        self.assertRedirects(response, reverse('dashboard'))
    
    def test_login_failure(self):
        response = self.client.post(reverse('login'), {
            'username': 'testuser@example.com',
            'password': 'wrongpassword'
        })
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, 'Please enter a correct email and password')
