from django.shortcuts import redirect
from django.contrib import messages
from functools import wraps

def system_owner_required(view_func):
    """
    Decorator to ensure only system owners can access a view
    """
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        if hasattr(request.user, 'is_system_owner') and request.user.is_system_owner:
            return view_func(request, *args, **kwargs)
        messages.error(request, "Access denied. System owner privileges required.")
        return redirect('dashboard')
    return _wrapped_view
