# Generated by Django 5.2.5 on 2025-10-30 19:37

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('branches', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SupplierCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField(blank=True)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name_plural': 'Supplier Categories',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Supplier',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(blank=True, max_length=200, unique=True)),
                ('supplier_type', models.CharField(choices=[('company', 'Company'), ('individual', 'Individual'), ('government', 'Government'), ('other', 'Other')], default='company', max_length=20)),
                ('company_name', models.CharField(blank=True, max_length=200)),
                ('tax_identification_number', models.CharField(blank=True, max_length=50, verbose_name='Tax ID')),
                ('registration_number', models.CharField(blank=True, max_length=50, verbose_name='Registration #')),
                ('vat_number', models.CharField(blank=True, max_length=50, verbose_name='VAT Number')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='Email Address')),
                ('phone', models.CharField(blank=True, max_length=20)),
                ('mobile', models.CharField(blank=True, max_length=20)),
                ('website', models.URLField(blank=True, verbose_name='Website')),
                ('address_line1', models.CharField(blank=True, max_length=255, verbose_name='Address Line 1')),
                ('address_line2', models.CharField(blank=True, max_length=255, verbose_name='Address Line 2')),
                ('city', models.CharField(blank=True, max_length=100)),
                ('state', models.CharField(blank=True, max_length=100)),
                ('postal_code', models.CharField(blank=True, max_length=20, verbose_name='Postal Code')),
                ('country', models.CharField(default='Kenya', max_length=100)),
                ('currency', models.CharField(default='KES', help_text='Default currency for transactions with this supplier', max_length=3)),
                ('payment_terms', models.CharField(choices=[('net_7', 'Net 7 Days'), ('net_15', 'Net 15 Days'), ('net_30', 'Net 30 Days'), ('net_60', 'Net 60 Days'), ('due_on_receipt', 'Due on Receipt'), ('prepaid', 'Prepaid')], default='net_30', max_length=20)),
                ('credit_limit', models.DecimalField(decimal_places=2, default=0, help_text='Credit limit for this supplier', max_digits=12)),
                ('is_active', models.BooleanField(default=True)),
                ('preferred', models.BooleanField(default=False, help_text='Mark as preferred supplier')),
                ('account_balance', models.DecimalField(decimal_places=2, default=0, help_text='Current account balance', max_digits=12)),
                ('total_purchases', models.DecimalField(decimal_places=2, default=0, help_text='Total purchases from this supplier', max_digits=12)),
                ('total_payments', models.DecimalField(decimal_places=2, default=0, help_text='Total payments made to this supplier', max_digits=12)),
                ('notes', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('branches', models.ManyToManyField(blank=True, related_name='suppliers', to='branches.branch')),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_suppliers', to=settings.AUTH_USER_MODEL)),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='suppliers', to='suppliers.suppliercategory')),
            ],
            options={
                'verbose_name_plural': 'Suppliers',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='SupplierContact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('position', models.CharField(blank=True, max_length=100)),
                ('email', models.EmailField(blank=True, max_length=254)),
                ('phone', models.CharField(blank=True, max_length=20)),
                ('mobile', models.CharField(blank=True, max_length=20)),
                ('is_primary', models.BooleanField(default=False, help_text='Primary contact for the supplier')),
                ('contact_type', models.CharField(choices=[('primary', 'Primary Contact'), ('billing', 'Billing Contact'), ('technical', 'Technical Contact'), ('other', 'Other')], default='primary', max_length=20)),
                ('notes', models.TextField(blank=True)),
                ('supplier', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contacts', to='suppliers.supplier')),
            ],
            options={
                'verbose_name': 'Supplier Contact',
                'verbose_name_plural': 'Supplier Contacts',
                'ordering': ['-is_primary', 'last_name', 'first_name'],
            },
        ),
        migrations.CreateModel(
            name='SupplierDocument',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('document_type', models.CharField(choices=[('contract', 'Contract'), ('agreement', 'Agreement'), ('license', 'License'), ('certificate', 'Certificate'), ('other', 'Other')], default='other', max_length=20)),
                ('title', models.CharField(max_length=200)),
                ('file', models.FileField(upload_to='supplier_documents/%Y/%m/%d/')),
                ('description', models.TextField(blank=True)),
                ('valid_from', models.DateField(blank=True, null=True)),
                ('valid_to', models.DateField(blank=True, null=True)),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('supplier', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='documents', to='suppliers.supplier')),
                ('uploaded_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-valid_to', '-uploaded_at'],
            },
        ),
        migrations.CreateModel(
            name='SupplierNote',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('note', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_supplier_notes', to=settings.AUTH_USER_MODEL)),
                ('supplier', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='supplier_notes', to='suppliers.supplier')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
    ]
