from django import template

register = template.Library()

@register.filter
def dictsortreversed(value, arg):
    """
    Takes a list of dicts, returns that list sorted by the property given in
    the argument in descending order.
    """
    try:
        return sorted(value, key=lambda x: x[arg], reverse=True)
    except (KeyError, AttributeError):
        return []
