from django.contrib import admin
from .models import License

@admin.register(License)
class LicenseAdmin(admin.ModelAdmin):
    list_display = ('license_key', 'branch', 'issue_date', 'expiry_date', 'is_active')
    list_filter = ('is_active', 'issue_date', 'expiry_date')
    search_fields = ('license_key', 'branch__name')
    date_hierarchy = 'issue_date'
