from django.urls import path
from . import views

app_name = 'expenses'

urlpatterns = [
    # Expense URLs
    path('', views.ExpenseListView.as_view(), name='expense_list'),
    path('create/', views.ExpenseCreateView.as_view(), name='expense_create'),
    path('<int:pk>/', views.ExpenseDetailView.as_view(), name='expense_detail'),
    path('<int:pk>/edit/', views.ExpenseUpdateView.as_view(), name='expense_edit'),
    path('<int:pk>/delete/', views.ExpenseDeleteView.as_view(), name='expense_delete'),
    
    # Category URLs
    path('categories/', views.ExpenseCategoryListView.as_view(), name='category_list'),
    path('categories/create/', views.ExpenseCategoryCreateView.as_view(), name='category_create'),
    path('categories/<int:pk>/edit/', views.ExpenseCategoryUpdateView.as_view(), name='category_edit'),
    path('categories/<int:pk>/delete/', views.ExpenseCategoryDeleteView.as_view(), name='category_delete'),
    
    # Export URL
    path('export/', views.ExpenseExportView.as_view(), name='export_expenses'),
    
    # Quick add category
    path('categories/quick-add/', views.QuickAddCategoryView.as_view(), name='category_quick_add'),
    
    # Print expense
    path('<int:pk>/print/', views.ExpensePrintView.as_view(), name='expense_print'),
    
    # Export single expense
    path('<int:pk>/export/', views.SingleExpenseExportView.as_view(), name='expense_export'),
    
    # Cashier expense creation
    path('cashier/add/', views.CashierExpenseCreateView.as_view(), name='cashier_expense_create'),
]
