from django.urls import path
from . import views

urlpatterns = [
    # Customer CRUD URLs
    path('', views.customer_list, name='customer_list'),
    path('add/', views.customer_add, name='customer_add'),
    path('<int:customer_id>/', views.customer_detail, name='customer_detail'),
    path('<int:customer_id>/edit/', views.customer_edit, name='customer_edit'),
    path('<int:customer_id>/delete/', views.customer_delete, name='customer_delete'),
    
    # API endpoints
    path('api/list/', views.customer_list_api, name='customer_list_api'),
    path('api/create/', views.customer_create_api, name='customer_create_api'),
]