from django import forms
from .models import License
from branches.models import Branch

class LicenseForm(forms.Form):
    """
    Form for creating a new license
    """
    branch = forms.ModelChoiceField(
        queryset=Branch.objects.filter(is_active=True),
        widget=forms.Select(attrs={'class': 'form-control'}),
        empty_label="Select a branch",
        required=True
    )
    
    duration = forms.ChoiceField(
        choices=[
            (30, '30 days'),
            (90, '90 days'),
            (180, '6 months'),
            (365, '1 year'),
            (730, '2 years'),
        ],
        widget=forms.Select(attrs={'class': 'form-control'}),
        required=True,
        initial=365
    )
    
    def clean_duration(self):
        """
        Convert duration to integer
        """
        duration = self.cleaned_data.get('duration')
        return int(duration)


class LicenseActivationForm(forms.Form):
    """
    Form for activating a license
    """
    license_key = forms.CharField(
        max_length=100,
        widget=forms.TextInput(attrs={'class': 'form-control'}),
        required=True
    )
    
    company_name = forms.CharField(
        max_length=100,
        widget=forms.TextInput(attrs={'class': 'form-control'}),
        required=True
    )
    
    address = forms.CharField(
        widget=forms.Textarea(attrs={'class': 'form-control', 'rows': 3}),
        required=True
    )
    
    contact_email = forms.EmailField(
        widget=forms.EmailInput(attrs={'class': 'form-control'}),
        required=True
    )
    
    contact_phone = forms.CharField(
        max_length=20,
        widget=forms.TextInput(attrs={'class': 'form-control'}),
        required=True
    )