from django.urls import path
from django.shortcuts import redirect
from . import views

app_name = 'expenses'

urlpatterns = [
    # Expense views
    path('', views.ExpenseListView.as_view(), name='expense_list'),
    path('create/', views.ExpenseCreateView.as_view(), name='expense_create'),
    path('<int:pk>/', views.ExpenseDetailView.as_view(), name='expense_detail'),
    path('<int:pk>/edit/', views.ExpenseUpdateView.as_view(), name='expense_edit'),
    path('<int:pk>/delete/', views.ExpenseDeleteView.as_view(), name='expense_delete'),
    
    # Expense actions - redirecting to class-based views where available
    path('<int:pk>/submit/', lambda request, pk: redirect('expenses:expense_edit', pk=pk), name='expense_submit'),
    path('<int:pk>/approve/', views.ExpenseApproveView.as_view(), name='expense_approve'),
    path('<int:pk>/reject/', views.ExpenseRejectView.as_view(), name='expense_reject'),
    path('<int:pk>/pay/', views.ExpensePayView.as_view(), name='expense_pay'),
    
    # Export and print
    path('export/', views.export_expenses, name='export_expenses'),
    path('<int:pk>/print/', views.ExpenseDetailView.as_view(template_name='expenses/expense_print.html'), name='expense_print'),
    
    # Categories
    path('categories/', views.ExpenseCategoryListView.as_view(), name='category_list'),
    path('categories/create/', views.ExpenseCategoryCreateView.as_view(), name='category_create'),
    path('categories/<int:pk>/edit/', views.ExpenseCategoryUpdateView.as_view(), name='category_edit'),
    path('categories/<int:pk>/delete/', views.ExpenseCategoryDeleteView.as_view(), name='category_delete'),
    
    # Dashboard
    path('dashboard/', views.expense_dashboard, name='expense_dashboard'),
    
    # API endpoints
    path('api/expenses/autocomplete/', views.expense_autocomplete, name='expense_autocomplete'),
]
