"""
URL configuration for asaploads_pos project.
"""

from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from django.views.generic import RedirectView

urlpatterns = [
    path('admin/', admin.site.urls),
    path('', RedirectView.as_view(url='/dashboard/', permanent=True)),
    path('accounts/', include('accounts.urls')),
    path('dashboard/', include('core.urls')),
    path('sales/', include('sales.urls')),
    path('products/', include('products.urls')),
    path('customers/', include('customers.urls')),
    path('reports/', include('reports.urls')),
    path('branches/', include('branches.urls')),
    path('licenses/', include('licenses.urls')),
]

# Always serve media files regardless of DEBUG setting
# This is needed for development and test environments
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
