import os
import sys
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'asaploads_pos.settings')
django.setup()

from accounts.models import User
from core.models import CompanySettings

# Check if user already exists
if not User.objects.filter(email='admin@asaploads.com').exists():
    # Create a new admin user
    user = User.objects.create_superuser(
        email='admin@asaploads.com',
        first_name='Asaploads',
        last_name='Chronicles',
        password='@Ale/tech@freelancer.com'
    )
    print(f"Superuser {user.email} created successfully!")
    
    # Create company settings if not exists
    if not CompanySettings.objects.exists():
        company = CompanySettings.objects.create(
            company_name='AsapLoads POS Admin',
            company_address='Main Office',
            contact_email='admin@asaploads.com',
            contact_phone='123-456-7890',
            tax_rate=0.0,
            currency_symbol='$',
            receipt_footer='Thank you for your business!'
        )
        print(f"Company settings created for {company.company_name}")
else:
    print("Admin user already exists")