from django.urls import path
from . import views

urlpatterns = [
    # Sale URLs
    path('', views.sale_list, name='sale_list'),
    path('new/', views.new_sale, name='new_sale'),
    path('<int:sale_id>/', views.sale_detail, name='sale_detail'),
    path('<int:sale_id>/receipt/', views.sale_receipt, name='sale_receipt'),
    path('<int:sale_id>/payment/', views.add_payment, name='add_payment'),
    path('<int:sale_id>/cancel/', views.cancel_sale, name='cancel_sale'),
    
    # API endpoints
    path('api/product-search/', views.product_search, name='product_search'),
    path('api/save/', views.save_sale, name='save_sale'),
]