from django.urls import path
from django.contrib.auth.decorators import login_required
from . import views
from .report_views import (
    expenses_report, purchases_report, 
    quotations_report, suppliers_report
)

urlpatterns = [
    path('', views.reports_dashboard, name='reports'),
    path('sales/', views.sales_report, name='sales_report'),
    path('inventory/', views.inventory_report, name='inventory_report'),
    path('customers/', views.customers_report, name='customers_report'),
    path('cashiers/', views.cashiers_report, name='cashiers_report'),
    path('cashiers/<int:cashier_id>/', views.cashier_detail_report, name='cashier_detail_report'),
    path('export/sales/', views.export_sales_report, name='export_sales_report'),
    path('export/inventory/', views.export_inventory_report, name='export_inventory_report'),
    path('export/cashier/<int:cashier_id>/', views.export_cashier_sales_report, name='export_cashier_sales_report'),
    path('export/cashier-pdf/<int:cashier_id>/', views.export_cashier_sales_pdf_report, name='export_cashier_sales_pdf_report'),
    
    # New report URLs
    path('expenses/', login_required(expenses_report), name='expenses_report'),
    path('purchases/', login_required(purchases_report), name='purchases_report'),
    path('quotations/', login_required(quotations_report), name='quotations_report'),
    path('suppliers/', login_required(suppliers_report), name='suppliers_report'),
    
    # Export URLs will be added here when implemented
]
