from django.urls import path
from django.contrib.auth.decorators import login_required
from . import views

app_name = 'quotations'

urlpatterns = [
    # Quotation URLs
    path('', views.QuotationListView.as_view(), name='quotation_list'),
    path('create/', views.QuotationCreateView.as_view(), name='quotation_create'),
    path('<int:pk>/', views.QuotationDetailView.as_view(), name='quotation_detail'),
    path('<int:pk>/edit/', views.QuotationUpdateView.as_view(), name='quotation_edit'),
    path('<int:pk>/delete/', views.QuotationDeleteView.as_view(), name='quotation_delete'),
    path('<int:pk>/status/', views.change_quotation_status, name='quotation_status'),
    
    # Document and Note URLs
    path('<int:pk>/documents/add/', views.add_quotation_document, name='quotation_add_document'),
    path('<int:pk>/notes/add/', views.add_quotation_note, name='quotation_add_note'),
    path('<int:pk>/print/', views.quotation_print, name='quotation_print'),
]
