from django import forms
from .models import CompanySettings

class CompanySettingsForm(forms.ModelForm):
    """
    Form for company settings
    """
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        # Set default currency symbol to KES if not set
        if not self.instance.currency_symbol:
            self.instance.currency_symbol = 'KES'
    
    class Meta:
        model = CompanySettings
        fields = [
            'company_name', 'company_address', 'contact_email', 
            'contact_phone', 'logo', 'tax_rate', 'currency_symbol',
            'receipt_footer'
        ]
        widgets = {
            'company_name': forms.TextInput(attrs={'class': 'form-control'}),
            'company_address': forms.Textarea(attrs={'class': 'form-control', 'rows': 3}),
            'contact_email': forms.EmailInput(attrs={'class': 'form-control'}),
            'contact_phone': forms.TextInput(attrs={'class': 'form-control'}),
            'tax_rate': forms.NumberInput(attrs={'class': 'form-control', 'step': '0.01'}),
            'currency_symbol': forms.TextInput(attrs={'class': 'form-control', 'placeholder': 'KES'}),
            'receipt_footer': forms.Textarea(attrs={'class': 'form-control', 'rows': 3}),
        }
