from django.urls import path, include
from django.contrib.auth.decorators import login_required
from . import views
from .api import urls as api_urls

app_name = 'purchases'

urlpatterns = [
    # Purchase Orders
    path('', views.PurchaseOrderListView.as_view(), name='purchase_list'),
    path('create/', views.PurchaseOrderCreateView.as_view(), name='purchase_create'),
    path('<int:pk>/', views.PurchaseOrderDetailView.as_view(), name='purchase_detail'),
    path('<int:pk>/edit/', views.PurchaseOrderUpdateView.as_view(), name='purchase_edit'),
    path('<int:pk>/delete/', views.PurchaseOrderDeleteView.as_view(), name='purchase_delete'),
    
    # Goods Receipts
    path('<int:po_pk>/receipt/create/', views.GoodsReceiptCreateView.as_view(), name='goods_receipt_create'),
    path('receipt/<int:pk>/', views.GoodsReceiptDetailView.as_view(), name='goods_receipt_detail'),
    path('receipt/<int:pk>/print/', views.GoodsReceiptPrintView.as_view(), name='goods_receipt_print'),
    path('receipts/<int:pk>/', views.GoodsReceiptDetailView.as_view(), name='goods_receipt_detail_alt'),
    
    # API Endpoints
    path('api/', include(api_urls)),
]
