document.addEventListener('DOMContentLoaded', function() {
    // Function to update unit price when product is selected
    function updateUnitPrice(selectElement) {
        const productId = selectElement.value;
        const row = selectElement.closest('.form-row') || selectElement.closest('.row');
        const unitPriceInput = row ? row.querySelector('input[name$="-unit_price"]') : null;
        
        if (productId && unitPriceInput) {
            // Fetch the product details
            fetch(`/api/products/${productId}/`)
                .then(response => response.json())
                .then(data => {
                    if (data.cost_price) {
                        unitPriceInput.value = parseFloat(data.cost_price).toFixed(2);
                        // Trigger change event to update any dependent calculations
                        const event = new Event('change');
                        unitPriceInput.dispatchEvent(event);
                    }
                })
                .catch(error => console.error('Error fetching product details:', error));
        }
    }

    // Add event listeners to existing product selects
    document.querySelectorAll('select[id$="-product"]').forEach(select => {
        select.addEventListener('change', function() {
            updateUnitPrice(this);
        });
    });

    // Handle dynamically added forms
    document.addEventListener('formset:added', function(event) {
        const row = event.target;
        const productSelect = row.querySelector('select[id$="-product"]');
        if (productSelect) {
            productSelect.addEventListener('change', function() {
                updateUnitPrice(this);
            });
        }
    });
});
