# Generated by Django 5.2.1 on 2025-05-08 14:15

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('sales', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AddField(
            model_name='payment',
            name='notes',
            field=models.TextField(blank=True),
        ),
        migrations.AddField(
            model_name='payment',
            name='received_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='payment',
            name='payment_method',
            field=models.CharField(choices=[('cash', 'Cash'), ('mpesa', 'M-Pesa'), ('card', 'Credit/Debit Card'), ('transfer', 'Bank Transfer'), ('check', 'Check'), ('other', 'Other')], default='cash', max_length=10),
        ),
        migrations.AlterField(
            model_name='payment',
            name='reference_number',
            field=models.CharField(blank=True, help_text='For M-Pesa, enter the transaction code', max_length=100),
        ),
        migrations.CreateModel(
            name='MpesaPayment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone_number', models.CharField(max_length=15)),
                ('transaction_id', models.CharField(max_length=50, unique=True)),
                ('confirmation_code', models.CharField(blank=True, max_length=50, null=True, unique=True)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('completed', 'Completed'), ('failed', 'Failed')], default='pending', max_length=10)),
                ('processed_at', models.DateTimeField(auto_now_add=True)),
                ('payment', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='mpesa_details', to='sales.payment')),
            ],
        ),
    ]
