# This file serves as a WSGI entry point for Gunicorn
import os
import sys

# Get the absolute path of the project directory
project_path = os.path.dirname(os.path.abspath(__file__))

# Add Django project root to Python path
sys.path.append(project_path)
sys.path.append(os.path.join(project_path, 'asaploads_pos'))

# Set Django settings module
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'asaploads_pos.settings')

# Import the Django WSGI application
from django.core.wsgi import get_wsgi_application
app = get_wsgi_application()