# Generated by Django 5.2.5 on 2025-10-30 19:37

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('branches', '0001_initial'),
        ('purchases', '0002_expense_name_alter_expense_payment_method'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='PurchaseOrderItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.DecimalField(decimal_places=2, max_digits=10)),
                ('unit_price', models.DecimalField(decimal_places=2, max_digits=10)),
                ('total_price', models.DecimalField(decimal_places=2, editable=False, max_digits=12)),
                ('received_quantity', models.DecimalField(decimal_places=2, default=0, max_digits=10)),
            ],
        ),
        migrations.RemoveField(
            model_name='expense',
            name='branch',
        ),
        migrations.RemoveField(
            model_name='expense',
            name='category',
        ),
        migrations.RemoveField(
            model_name='expense',
            name='created_by',
        ),
        migrations.RemoveField(
            model_name='purchase',
            name='branch',
        ),
        migrations.RemoveField(
            model_name='purchase',
            name='created_by',
        ),
        migrations.RemoveField(
            model_name='purchase',
            name='supplier',
        ),
        migrations.RemoveField(
            model_name='purchaseitem',
            name='purchase',
        ),
        migrations.RemoveField(
            model_name='purchaseitem',
            name='product',
        ),
        migrations.CreateModel(
            name='GoodsReceipt',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('grn_number', models.CharField(max_length=50, unique=True)),
                ('received_date', models.DateField(default=django.utils.timezone.now)),
                ('notes', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('received_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-received_date', '-created_at'],
            },
        ),
        migrations.CreateModel(
            name='GoodsReceiptItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity_received', models.DecimalField(decimal_places=2, max_digits=10)),
                ('batch_number', models.CharField(blank=True, max_length=50)),
                ('expiry_date', models.DateField(blank=True, null=True)),
                ('goods_receipt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='purchases.goodsreceipt')),
            ],
        ),
        migrations.CreateModel(
            name='PurchaseOrder',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('po_number', models.CharField(max_length=50, unique=True)),
                ('order_date', models.DateField(default=django.utils.timezone.now)),
                ('expected_delivery_date', models.DateField(blank=True, null=True)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('completed', 'Completed'), ('cancelled', 'Cancelled')], default='pending', max_length=20)),
                ('notes', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='branches.branch')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='created_purchases', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-order_date', '-created_at'],
            },
        ),
    ]
