from django.db import models
from django.utils import timezone

class Branch(models.Model):
    """
    Branch model for multi-tenant functionality
    """
    name = models.CharField(max_length=100)
    address = models.TextField()
    phone = models.CharField(max_length=20, blank=True)
    email = models.EmailField(blank=True)
    is_active = models.BooleanField(default=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    def __str__(self):
        return self.name
    
    def has_valid_license(self):
        """
        Check if branch has a valid license
        """
        from licenses.models import License
        
        # Get the latest license for this branch
        license = License.objects.filter(branch=self, is_active=True).order_by('-expiry_date').first()
        
        # If no license or expired, return False
        if not license:
            return False
        
        if license.expiry_date < timezone.now():
            license.is_active = False
            license.save()
            return False
        
        return True
