"""
URL configuration for asaploads_pos project.
"""

from django.contrib import admin
from django.urls import path, include, re_path
from django.conf import settings
from django.conf.urls.static import static
from django.views.generic import RedirectView
from django.views.static import serve
from django.contrib.staticfiles.storage import staticfiles_storage
from django.views.generic.base import RedirectView as BaseRedirectView

urlpatterns = [
    path('admin/', admin.site.urls),
    path('', RedirectView.as_view(url='/dashboard/', permanent=True)),
    path('accounts/', include('accounts.urls')),
    path('dashboard/', include('core.urls')),
    path('sales/', include('sales.urls')),
    path('products/', include('products.urls')),
    path('customers/', include('customers.urls')),
    path('reports/', include('reports.urls')),  # Reports functionality
    path('branches/', include('branches.urls')),
    path('licenses/', include('licenses.urls')),
    path('expenses/', include('expenses.urls')),
    path('suppliers/', include('suppliers.urls')),
    path('purchases/', include('purchases.urls')),
    path('quotations/', include('quotations.urls')),
    
    # PWA URLs
    path('offline/', serve, {'path': 'pwa/offline.html', 'document_root': settings.STATIC_ROOT}, name='offline'),
    
    # Service Worker and Manifest
    re_path(r'^serviceworker\.js$', serve, {
        'path': 'pwa/serviceworker.js',
        'document_root': settings.STATIC_ROOT,
        'content_type': 'application/javascript'
    }),
    re_path(r'^manifest\.json$', serve, {
        'path': 'pwa/manifest.json',
        'document_root': settings.STATIC_ROOT,
        'content_type': 'application/json'
    }),
    re_path(r'^icons/icon-.*\.png$', serve, {
        'document_root': settings.STATIC_ROOT + '/pwa/icons/'
    }),
    
    # Favicon
    path('favicon.ico', BaseRedirectView.as_view(url=staticfiles_storage.url('pwa/icons/icon-192x192.png'))),
]

# Always serve media files regardless of DEBUG setting
# This is needed for development and test environments
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
