from django import template

register = template.Library()

@register.filter
def findall(queryset, key_value_pair):
    """
    Filter a queryset based on a key=value pair.
    
    Usage: {{ users|findall:"role=admin" }}
    """
    if not key_value_pair or '=' not in key_value_pair:
        return queryset
    
    key, value = key_value_pair.split('=', 1)
    
    filtered_items = []
    for item in queryset:
        try:
            if str(getattr(item, key)) == value:
                filtered_items.append(item)
        except AttributeError:
            pass
    
    return filtered_items